/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.dialog.comp.display.AbstractDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElementInsertHandler;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.Util;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class RectangleElementsDisplayModel
extends AbstractDisplayModel
implements MutiCharSetDisplayModel {
    private int fCharSet;
    protected DisplayElementInsertHandler fInsertHandler = new DisplayElementInsertHandler(this);
    protected CopyPasteHandler fCopyPasteHandler = new CopyPasteHandler(this);
    protected boolean insertMode = false;

    public RectangleElementsDisplayModel(Dimension displayDimension) {
        super(displayDimension);
    }

    public RectangleElementsDisplayModel(Dimension displayDimension, int charSet) {
        this(displayDimension);
        this.fCharSet = charSet;
    }

    public DisplayElement[][] getDisplayElements() {
        return this.fDisplayElements;
    }

    public boolean setElementAt(DisplayElement element, Point position) {
        if (this.insertMode) {
            if (!this.canPut(element, position)) {
                return false;
            }
            if (!this.fInsertHandler.insertElement(position, element)) {
                return false;
            }
        } else if (!this.overwriteElementAt(element, position)) {
            return false;
        }
        this.fireModelChangedEvent();
        return true;
    }

    public boolean deleteElement(Point location) {
        if (this.insertMode) {
            if (!this.fInsertHandler.deleteElement(location)) {
                return false;
            }
        } else {
            Rectangle deletedElementBounds = this.getElementBounds(location);
            int width = deletedElementBounds.width;
            int px = deletedElementBounds.getLocation().x;
            int py = deletedElementBounds.getLocation().y;
            for (int y = 0; y < deletedElementBounds.height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.fDisplayElements[px + x][py + y] = null;
                }
            }
        }
        this.fireModelChangedEvent();
        return true;
    }

    public boolean moveCells(List cells, Point destination) {
        if (this.insertMode) {
            return this.fInsertHandler.moveElements(destination, cells);
        }
        List elements = this.getCellsElements(cells);
        Rectangle former = this.getSelectedRectangle(cells);
        Rectangle current = new Rectangle(destination.x, destination.y, former.width, former.height);
        this.deleteCells(cells);
        if (!this.checkOverwriteArea(current)) {
            Iterator cellsIterator = cells.iterator();
            Iterator elementsIterator = elements.iterator();
            while (cellsIterator.hasNext()) {
                this.overwriteElementAt((DisplayElement)elementsIterator.next(), (Point)cellsIterator.next());
            }
            return false;
        }
        this.overwriteElements(destination, cells, elements);
        return true;
    }

    protected boolean overwriteElements(Point destination, List cells, List elements) {
        DisplayElementInsertHandler.AreaInfo areaInfo = new DisplayElementInsertHandler.AreaInfo(cells, elements);
        Dimension translationVector = new Dimension(destination.x - areaInfo.upperLeftCorner.x, destination.y - areaInfo.upperLeftCorner.y);
        Iterator elementsIterator = elements.iterator();
        Iterator cellsIterator = cells.iterator();
        while (cellsIterator.hasNext() && elementsIterator.hasNext()) {
            Point cell = (Point)cellsIterator.next();
            DisplayElement element = (DisplayElement)elementsIterator.next();
            Point destinationPoint = new Point(cell);
            destinationPoint.translate(translationVector.width, translationVector.height);
            this.putElementAt(element, destinationPoint);
        }
        return true;
    }

    protected Rectangle getMaxRectangle(Rectangle currentRectangle) {
        Point location = currentRectangle.getLocation();
        int xMin = location.x;
        int yMin = location.y;
        int xMax = location.x + currentRectangle.width - 1;
        int yMax = location.y + currentRectangle.height - 1;
        for (int height = currentRectangle.height - 1; height >= 0; --height) {
            for (int width = currentRectangle.width - 1; width >= 0; --width) {
                Point currentPoint = new Point(location.x + width, location.y + height);
                if (null == currentPoint) continue;
                Rectangle cellBounds = this.getElementBounds(currentPoint);
                if (cellBounds.x + cellBounds.width > xMax) {
                    xMax = cellBounds.x + cellBounds.width - 1;
                }
                if (cellBounds.x < xMin) {
                    xMin = cellBounds.x;
                }
                if (cellBounds.y + cellBounds.height > yMax) {
                    yMax = cellBounds.y + cellBounds.height - 1;
                }
                if (cellBounds.y >= yMin) continue;
                yMin = cellBounds.y;
            }
        }
        if (currentRectangle.equals(new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1))) {
            return currentRectangle;
        }
        return this.getMaxRectangle(new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1));
    }

    public Rectangle getSelectedRectangle(List selectedCells) {
        Iterator cells = selectedCells.iterator();
        int xMin = this.fDisplayDimension.width;
        int yMin = this.fDisplayDimension.width;
        int xMax = 0;
        int yMax = 0;
        while (cells.hasNext()) {
            Point currentPoint = (Point)cells.next();
            if (null == currentPoint) continue;
            Rectangle cellBounds = this.getElementBounds(currentPoint);
            if (cellBounds.x + cellBounds.width > xMax) {
                xMax = cellBounds.x + cellBounds.width - 1;
            }
            if (cellBounds.x < xMin) {
                xMin = cellBounds.x;
            }
            if (cellBounds.y + cellBounds.height > yMax) {
                yMax = cellBounds.y + cellBounds.height - 1;
            }
            if (cellBounds.y >= yMin) continue;
            yMin = cellBounds.y;
        }
        return this.getMaxRectangle(new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1));
    }

    public boolean replaceBarElement(Point focus, Point destination, DisplayElement newElement) {
        if (this.insertMode) {
            if (!this.fInsertHandler.replaceBarElement(focus, destination, newElement)) {
                return false;
            }
        } else {
            DisplayElement preDisp = this.getElementAt(focus);
            this.putElementAt(null, focus);
            Rectangle current = new Rectangle(destination.x, destination.y, newElement.getWidth(), newElement.getHeight());
            if (!this.checkOverwriteArea(current)) {
                this.putElementAt(preDisp, focus);
                return false;
            }
            this.setElementAt(newElement, destination);
        }
        this.fireModelChangedEvent();
        return true;
    }

    public boolean deleteCells(List cells) {
        Rectangle selectRectangle = this.getSelectedRectangle(cells);
        Point destination = selectRectangle.getLocation();
        if (this.insertMode) {
            if (!this.fInsertHandler.deleteElements(cells)) {
                return false;
            }
        } else {
            for (int y = 0; y < selectRectangle.height; ++y) {
                for (int x = 0; x < selectRectangle.width; ++x) {
                    this.fDisplayElements[destination.x + x][destination.y + y] = null;
                }
            }
        }
        this.fireModelChangedEvent();
        return true;
    }

    public boolean isCopyPasteSupported() {
        return true;
    }

    private boolean checkBounds(Rectangle dimension) {
        if (!new Rectangle(this.fDisplayDimension).contains(dimension)) {
            return false;
        }
        Point location = dimension.getLocation();
        for (int height = dimension.height - 1; height >= 0; --height) {
            for (int width = dimension.width - 1; width >= 0; --width) {
                Point target = new Point(location.x + width, location.y + height);
                if (null == this.getElementAt(target) || dimension.contains(this.getElementBounds(target))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkBounds(Point destination, DisplayElementInsertHandler.AreaInfo areaInfo) {
        Point upperLeftCorner = areaInfo.upperLeftCorner;
        Rectangle screen = new Rectangle(this.fDisplayDimension);
        for (int y = 0; y < areaInfo.height; ++y) {
            Rectangle lineRectangle = new Rectangle(destination.x, destination.y + y, areaInfo.lengths[y], 1);
            if (!lineRectangle.isEmpty() && !screen.contains(lineRectangle)) {
                return false;
            }
            int dx = upperLeftCorner.x - destination.x;
            int dy = upperLeftCorner.y - destination.y;
            for (int x = destination.x; x < destination.x + areaInfo.lengths[y]; ++x) {
                Point target = new Point(x, destination.y + y);
                Rectangle bound = this.getElementBounds(target);
                bound.translate(dx, dy);
                if (null == this.getElementAt(target) || areaInfo.contains(bound)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkOverwriteArea(Point destination, DisplayElementInsertHandler.AreaInfo areaInfo) {
        return this.checkBounds(destination, areaInfo);
    }

    protected boolean checkOverwriteArea(Rectangle dimension) {
        return this.checkBounds(dimension);
    }

    public boolean isBiWidthCharacterset() {
        return MessageGlobalInfo.isBiWidthCharSet(this.getCharSet());
    }

    public int getCharSet() {
        return this.fCharSet;
    }

    public boolean paste(Transferable clipboardContents, Point destination) {
        if (this.fCopyPasteHandler.pastePrepare(clipboardContents, destination)) {
            DisplayElementInsertHandler.AreaInfo areaInfo = new DisplayElementInsertHandler.AreaInfo(this.fCopyPasteHandler.getCells(), this.fCopyPasteHandler.getElements());
            if (areaInfo.height > this.fDisplayDimension.height) {
                Object[] additionalInformation = new Object[]{new Double(this.fDisplayDimension.height)};
                new LogoError(null, "dialog.parameter.message.moreThanFourLinesNotAllowed", "The number of pasted lines is up to " + this.fDisplayDimension.height, additionalInformation, 2, 0).display();
                return true;
            }
            for (int i = 0; i < areaInfo.height; ++i) {
                if (areaInfo.lengths[i] <= this.fDisplayDimension.width) continue;
                new LogoError(null, "dialog.parameter.message.tooCharacterInOneLines", "Too many characters in one line.", 2, 0).display();
                return true;
            }
            if (this.insertMode) {
                if (!this.fInsertHandler.insertElements(destination, this.fCopyPasteHandler.getCells(), this.fCopyPasteHandler.getElements())) {
                    return false;
                }
            } else {
                if (!this.checkOverwriteArea(destination, areaInfo)) {
                    return false;
                }
                this.overwriteElements(destination, this.fCopyPasteHandler.getCells(), this.fCopyPasteHandler.getElements());
            }
            this.fireModelChangedEvent();
            return true;
        }
        return false;
    }

    protected boolean overwriteElementAt(DisplayElement element, Point position) {
        int width;
        int height = element == null ? 1 : element.getHeight();
        int n = width = element == null ? 1 : element.getWidth();
        if (!this.checkOverwriteArea(new Rectangle(position.x, position.y, width, height))) {
            return false;
        }
        return this.putElementAt(element, position);
    }

    protected boolean putElementAt(DisplayElement element, Point position) {
        if (!this.canPut(element, position)) {
            return false;
        }
        int height = element == null ? 1 : element.getHeight();
        int width = element == null ? 1 : element.getWidth();
        for (int x = position.x; x < position.x + width; ++x) {
            for (int y = position.y; y < position.y + height; ++y) {
                this.fDisplayElements[x][y] = null;
            }
        }
        this.fDisplayElements[position.x][position.y] = element;
        return true;
    }

    public void setInsertMode(boolean insertMode) {
        this.insertMode = insertMode;
    }

    public boolean isEmptyCell(Point cell) {
        DisplayElement displayElement = this.getElementAt(cell);
        if (displayElement == null) {
            return true;
        }
        return displayElement instanceof DefaultDisplayElement && ((DefaultDisplayElement)displayElement).getUserObject().toString().trim().equals("");
    }

    public boolean isCharacterSupported(char c) {
        int charSet = this.getCharSet();
        return MessageGlobalInfo.getCharsetEncoding(charSet, c) != null;
    }

    private static class CopyPasteHandler {
        protected RectangleElementsDisplayModel fDisplayModel;
        private List fCells = new Vector();
        private List fElements = new Vector();

        public CopyPasteHandler(RectangleElementsDisplayModel model) {
            this.fDisplayModel = model;
        }

        public List getCells() {
            return this.fCells;
        }

        public List getElements() {
            return this.fElements;
        }

        public boolean pastePrepare(Transferable clipboardContents, Point destination) {
            try {
                DataFlavor flavor = new DataFlavor("application/x-java-logo-display-cells;class=java.util.List");
                if (clipboardContents.isDataFlavorSupported(flavor)) {
                    Hashtable content = (Hashtable)clipboardContents.getTransferData(flavor);
                    this.fCells = this.deepCopyPointList((List)content.get("cells"));
                    this.fElements = this.deepCopyDisplayElementList((List)content.get("elements"));
                    this.adjustElements();
                    return true;
                }
                if (clipboardContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String stringContents = (String)clipboardContents.getTransferData(DataFlavor.stringFlavor);
                    this.transferStringToDisplayElements(stringContents);
                    return true;
                }
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (UnsupportedFlavorException uf) {
                uf.printStackTrace();
            }
            catch (IOException ioE) {
                ioE.printStackTrace();
            }
            return false;
        }

        private void transferStringToDisplayElements(String contents) {
            this.fCells.clear();
            this.fElements.clear();
            String stringContents = this.stringHandler(contents);
            String[] line = stringContents.split("\n");
            for (int y = 0; y < line.length; ++y) {
                int insertIndex = 0;
                for (int x = 0; x < line[y].length(); ++x) {
                    DefaultDisplayElement disp;
                    Point insertPoint = new Point(insertIndex, y);
                    char ch = line[y].charAt(x);
                    int code = MessageParameter.getSpecialCharacterCode(ch);
                    if (code != -1) {
                        if (this.isBiWidthCharacterset()) {
                            disp = new SpecialCharacterDisplayElement(Character.toString(ch), code, 2, 1);
                            insertIndex += 2;
                        } else {
                            disp = new SpecialCharacterDisplayElement(Character.toString(ch), code, 1, 1);
                            ++insertIndex;
                        }
                    } else if (!this.isCharacterSupported(ch)) {
                        disp = new DefaultDisplayElement(" ", 1, 1);
                        insertIndex = ch > '\u00ff' ? (insertIndex += 2) : ++insertIndex;
                    } else if (this.isBiWidthCharacterset() && ch > '\u007f') {
                        disp = new DefaultDisplayElement(Character.valueOf(ch), 2, 1);
                        insertIndex += 2;
                    } else {
                        disp = new DefaultDisplayElement(Character.valueOf(ch), 1, 1);
                        ++insertIndex;
                    }
                    this.fCells.add(new Point(insertPoint.x, insertPoint.y));
                    this.fElements.add(disp);
                }
            }
        }

        private boolean isBiWidthCharacterset() {
            return this.fDisplayModel.isBiWidthCharacterset();
        }

        private List deepCopyDisplayElementList(List elements) {
            ArrayList<DisplayElement> ret = new ArrayList<DisplayElement>();
            for (DisplayElement element : elements) {
                if (element == null) {
                    ret.add(element);
                    continue;
                }
                ret.add((DisplayElement)Util.deepCopy(element));
            }
            return ret;
        }

        private List deepCopyPointList(List pointList) {
            ArrayList<Point> ret = new ArrayList<Point>();
            for (Point p : pointList) {
                ret.add(new Point(p));
            }
            return ret;
        }

        private void adjustElements() {
            for (DisplayElement element : this.fElements) {
                if (element instanceof DefaultDisplayElement) {
                    if (element instanceof SpecialCharacterDisplayElement || this.isCharacterSupported(element.toString().charAt(0))) continue;
                    ((DefaultDisplayElement)element).setUserObject(" ");
                    ((DefaultDisplayElement)element).setWidth(1);
                    continue;
                }
                if (element != null) continue;
                element = new DefaultDisplayElement(" ", 1, 1);
            }
            Iterator cellsIterator = this.fCells.iterator();
            Iterator elementsIterator = this.fElements.iterator();
            int lenthAdjust = 0;
            int lineIndex = 0;
            while (cellsIterator.hasNext() && elementsIterator.hasNext()) {
                Point cell = (Point)cellsIterator.next();
                DisplayElement element = (DisplayElement)elementsIterator.next();
                if (lineIndex != cell.y) {
                    lenthAdjust = 0;
                    lineIndex = cell.y;
                }
                cell.translate(lenthAdjust, 0);
                if (element instanceof SpecialCharacterDisplayElement) {
                    if (this.fDisplayModel.isBiWidthCharacterset() && element.getWidth() != 2) {
                        ((SpecialCharacterDisplayElement)element).setWidth(2);
                        ++lenthAdjust;
                    }
                    if (this.fDisplayModel.isBiWidthCharacterset() || element.getWidth() == 1) continue;
                    ((SpecialCharacterDisplayElement)element).setWidth(1);
                    --lenthAdjust;
                    continue;
                }
                if (!(element instanceof DefaultDisplayElement)) continue;
                if (this.fDisplayModel.isBiWidthCharacterset() && element.toString().charAt(0) > '\u007f' && element.getWidth() != 2) {
                    ((DefaultDisplayElement)element).setWidth(2);
                    ++lenthAdjust;
                }
                if (this.fDisplayModel.isBiWidthCharacterset() || element.toString().charAt(0) <= '\u007f' || element.getWidth() == 1) continue;
                ((DefaultDisplayElement)element).setWidth(1);
                --lenthAdjust;
            }
        }

        private String stringHandler(String insertedString) {
            String ret = "";
            ret = insertedString.replace("\t", " ");
            ret = ret.replace("\r", "");
            while (ret.startsWith("\n")) {
                ret = ret.substring(1);
            }
            while (ret.endsWith("\n")) {
                ret = ret.substring(0, ret.length() - 1);
            }
            return ret;
        }

        private boolean isCharacterSupported(char c) {
            return this.fDisplayModel.isCharacterSupported(c);
        }
    }
}

